<?php
session_start();
require 'db.php';

if(!isset($_SESSION['usuario_id'])) header("Location: index.php");

$usuario_id = $_SESSION['usuario_id'];

if(isset($_GET['id'])){
    $id = (int) $_GET['id'];

    // Busca a provisão
    $stmt = $pdo->prepare("SELECT * FROM provisoes WHERE id=? AND usuario_id=? AND status='pendente'");
    $stmt->execute([$id, $usuario_id]);
    $provisao = $stmt->fetch();

    if($provisao){
        // Insere no caixa como saída
        $stmtMov = $pdo->prepare("INSERT INTO movimentos (usuario_id, tipo, descricao, valor, data_movimento) VALUES (?,?,?,?, NOW())");
        $stmtMov->execute([$usuario_id, 'saida', $provisao['descricao'], $provisao['valor']]);

        // Atualiza provisão para paga
        $stmtUp = $pdo->prepare("UPDATE provisoes SET status='paga' WHERE id=?");
        $stmtUp->execute([$id]);
    }
}

header("Location: dashboard.php");
exit;
