<?php
session_start();
require 'db.php';
if(!isset($_SESSION['usuario_id'])) header("Location: index.php");

$usuario_id = $_SESSION['usuario_id'];
$msg = "";

// Salvar nova conta fixa
if(isset($_POST['salvar'])){
    $descricao = trim($_POST['descricao']);
    $valor = floatval($_POST['valor']);
    $dia_vencimento = intval($_POST['dia_vencimento']);

    if($descricao && $valor > 0 && $dia_vencimento > 0){
        $stmt = $pdo->prepare("INSERT INTO contas_fixas (usuario_id, descricao, valor, dia_vencimento) VALUES (?,?,?,?)");
        $stmt->execute([$usuario_id, $descricao, $valor, $dia_vencimento]);
        $msg = "✅ Conta fixa cadastrada com sucesso!";
    } else {
        $msg = "⚠ Preencha todos os campos corretamente.";
    }
}

// Excluir conta fixa
if(isset($_GET['excluir'])){
    $id = (int)$_GET['excluir'];
    $stmt = $pdo->prepare("DELETE FROM contas_fixas WHERE id=? AND usuario_id=?");
    $stmt->execute([$id, $usuario_id]);
    $msg = "❌ Conta fixa excluída!";
}

// Buscar contas fixas do usuário
$stmt = $pdo->prepare("SELECT * FROM contas_fixas WHERE usuario_id=? ORDER BY dia_vencimento ASC");
$stmt->execute([$usuario_id]);
$contas = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<title>Contas Fixas</title>
<link rel="stylesheet" href="css/style.css">
<style>
.container { max-width:800px; margin:30px auto; background:#fff; padding:20px; border-radius:8px; box-shadow:0 0 10px rgba(0,0,0,0.1);}
h1 { margin-bottom:20px; }
form input, form select { width:80%; padding:8px; margin-top:5px; border:1px solid #ccc; border-radius:5px; }
table { width:100%; border-collapse:collapse; margin-top:20px; }
th, td { border:1px solid #ccc; padding:8px; text-align:left; }
th { background:#eee; }
.msg { margin:10px 0; font-weight:bold; color:green; }
a.btn { padding:5px 10px; border-radius:5px; text-decoration:none; color:#fff; }
.btn-edit { background:#28a745; }
.btn-delete { background:#dc3545; }
.btn-edit:hover { background:#218838; }
.btn-delete:hover { background:#c82333; }
</style>
</head>
<body>
<div class="container">
    <h1>📌 Contas Fixas</h1>
    <!-- Botão Voltar -->
    <a href="dashboard.php" style="display:inline-block; margin-bottom:15px; padding:8px 12px; background:#007bff; color:#fff; text-decoration:none; border-radius:5px;">⬅ Voltar ao Dashboard</a>


    <?php if($msg): ?>
        <p class="msg"><?= $msg ?></p>
    <?php endif; ?>

    <!-- Formulário -->
    <h2>Nova Conta Fixa</h2>
    <form method="POST">
        <input type="text" name="descricao" placeholder="Descrição" required><br>
        <input type="number" step="0.01" name="valor" placeholder="Valor (R$)" required><br>
        <input type="number" name="dia_vencimento" min="1" max="31" placeholder="Dia de Vencimento" required><br>
        <button type="submit" name="salvar">Salvar</button>
    </form>

    <!-- Listagem -->
    <h2>Contas Fixas Cadastradas</h2>
    <table>
        <tr>
            <th>Dia Vencimento</th>
            <th>Descrição</th>
            <th>Valor (R$)</th>
            <th>Ações</th>
        </tr>
        <?php if($contas): foreach($contas as $c): ?>
        <tr>
            <td><?= $c['dia_vencimento'] ?></td>
            <td><?= htmlspecialchars($c['descricao']) ?></td>
            <td><?= number_format($c['valor'],2,',','.') ?></td>
            <td>
                <a href="editar_conta_fixa.php?id=<?= $c['id'] ?>" class="btn btn-edit">Editar</a>
                <a href="contas_fixas.php?excluir=<?= $c['id'] ?>" class="btn btn-delete" onclick="return confirm('Excluir conta fixa?')">Excluir</a>
            </td>
        </tr>
        <?php endforeach; else: ?>
        <tr><td colspan="4">Nenhuma conta fixa cadastrada.</td></tr>
        <?php endif; ?>
    </table>
</div>
</body>
</html>
