<?php
session_start();
require 'db.php';
if(!isset($_SESSION['usuario_id'])) header("Location: index.php");

$usuario_id = $_SESSION['usuario_id'];

// Período selecionado
$mes = isset($_GET['mes']) ? (int)$_GET['mes'] : date('m');
$ano = isset($_GET['ano']) ? (int)$_GET['ano'] : date('Y');
$inicio = "$ano-$mes-01";
$fim = date("Y-m-t", strtotime($inicio)); // último dia do mês

// Entradas
$stmtEntradas = $pdo->prepare("SELECT SUM(valor) as total FROM movimentos WHERE usuario_id=? AND tipo='entrada' AND data_movimento BETWEEN ? AND ?");
$stmtEntradas->execute([$usuario_id, $inicio, $fim]);
$totalEntradas = $stmtEntradas->fetch()['total'] ?? 0;

// Saídas
$stmtSaidas = $pdo->prepare("SELECT SUM(valor) as total FROM movimentos WHERE usuario_id=? AND tipo='saida' AND data_movimento BETWEEN ? AND ?");
$stmtSaidas->execute([$usuario_id, $inicio, $fim]);
$totalSaidas = $stmtSaidas->fetch()['total'] ?? 0;

// Totais por meio de pagamento (entradas)
$stmtMeios = $pdo->prepare("
    SELECT meio_pagamento, SUM(valor) as total 
    FROM movimentos 
    WHERE usuario_id=? AND tipo='entrada' AND data_movimento BETWEEN ? AND ? 
    GROUP BY meio_pagamento
");
$stmtMeios->execute([$usuario_id, $inicio, $fim]);
$totaisMeio = $stmtMeios->fetchAll(PDO::FETCH_KEY_PAIR); // cria array ['Em mãos' => valor, 'Iugu' => valor, ...]

// Garantir que todos os meios existam no array
$totaisMeio['Em mãos'] = $totaisMeio['Em mãos'] ?? 0;
$totaisMeio['Iugu'] = $totaisMeio['Iugu'] ?? 0;
$totaisMeio['Itau'] = $totaisMeio['Itau'] ?? 0;


// Saldo
$saldo = $totalEntradas - $totalSaidas;

// Movimentos recentes do mês
$stmtMovimentos = $pdo->prepare("SELECT * FROM movimentos WHERE usuario_id=? AND data_movimento BETWEEN ? AND ? ORDER BY data_movimento DESC");
$stmtMovimentos->execute([$usuario_id, $inicio, $fim]);
$movimentos = $stmtMovimentos->fetchAll();

$totalMovimentos = 0;
foreach($movimentos as $m){
    $totalMovimentos += $m['valor'];
}


// Provisões pendentes do mês
$stmtProvisoes = $pdo->prepare("SELECT * FROM provisoes WHERE usuario_id=? AND status='pendente' AND data_prevista BETWEEN ? AND ? ORDER BY data_prevista ASC");
$stmtProvisoes->execute([$usuario_id, $inicio, $fim]);
$provisoes = $stmtProvisoes->fetchAll();

// Contas fixas do usuário
$stmtContas = $pdo->prepare("SELECT * FROM contas_fixas WHERE usuario_id=? AND status='ativo' ORDER BY dia_vencimento ASC");
$stmtContas->execute([$usuario_id]);
$contasFixas = $stmtContas->fetchAll();

// Pagamentos do mês atual
$mesReferencia = "$ano-$mes-01";
$stmtPagos = $pdo->prepare("SELECT conta_id FROM contas_fixas_pagamentos WHERE mes_referencia=?");
$stmtPagos->execute([$mesReferencia]);
$pagos = $stmtPagos->fetchAll();
$pagamentosMes = array_column($pagos, 'conta_id');

// Estatística de contas fixas
$totalFixas = count($contasFixas);
$fixasPagas = count(array_intersect($pagamentosMes, array_column($contasFixas,'id')));
$fixasPendentes = $totalFixas - $fixasPagas;
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="utf-8">
    <title>Dashboard - Livro Caixa</title>
    <link rel="stylesheet" href="css/style.css">
    <style>
        body { font-family: Arial,sans-serif; background:#f4f4f4; margin:0; padding:0; }
        .container { max-width: 1200px; margin: 30px auto; background:#fff; padding:20px; border-radius:8px; box-shadow:0 0 10px rgba(0,0,0,0.1);}
        h1, h2 { color:#333; margin-top:20px; }
        nav { margin-bottom:20px; }
        nav a { margin-right:15px; text-decoration:none; color:#007bff; font-weight:bold;}
        nav a:hover { text-decoration:underline; }
        table { width:100%; border-collapse: collapse; margin-top:10px; }
        th, td { border:1px solid #ccc; padding:8px; text-align:left; }
        th { background:#eee; }
        .cards { display:flex; gap:20px; margin-bottom:20px; flex-wrap:wrap; }
        .card { flex:1; min-width:200px; padding:15px; background:#f8f9fa; border-radius:8px; text-align:center; box-shadow:0 2px 5px rgba(0,0,0,0.1);}
        .card h3 { margin:0; font-size:1.1em; color:#555; }
        .card p { margin:5px 0; font-size:1.4em; font-weight:bold; }
        .saldo { color:#28a745; }
        .status-pago { color:green; font-weight:bold; }
        .status-pendente { color:red; font-weight:bold; }
        .btn-pagar { display:inline-block; padding:5px 10px; background:#007bff; color:#fff; text-decoration:none; border-radius:5px; font-size:0.9em;}
        .btn-pagar:hover { background:#0056b3; }
        form.filtro { margin-bottom:20px; }
        form.filtro select, form.filtro button { padding:5px 10px; margin-right:10px; }
    </style>
    
</head>
<body>
    
    
<div class="container">
    <img align="center" src="img/logo3.png" />
    
    <h2>Livro Caixa <?= str_pad($mes,2,'0',STR_PAD_LEFT) ?>/<?= $ano ?></h2>
    
                    <!-- Filtro -->
    <form method="GET" class="filtro">
        <label>Mês:</label>
        <select name="mes">
            <?php for($m=1;$m<=12;$m++): ?>
                <option value="<?= $m ?>" <?= $m==$mes ? 'selected' : '' ?>>
                    <?= str_pad($m,2,'0',STR_PAD_LEFT) ?>
                </option>
            <?php endfor; ?>
        </select>
        <label>Ano:</label>
        <select name="ano">
            <?php for($a=date('Y')-2;$a<=date('Y')+2;$a++): ?>
                <option value="<?= $a ?>" <?= $a==$ano ? 'selected' : '' ?>><?= $a ?></option>
            <?php endfor; ?>
        </select>
        <button type="submit">Filtrar</button>
    </form>
    
    
    
    
<nav class="menu-dashboard">
    <a href="dashboard.php"><span class="icon"></span> Dashboard</a>
    <a href="movimentos.php"><span class="icon"></span> Registrar Movimento</a>
    <a href="provisoes.php"><span class="icon"></span> Registrar Provisão</a>
    <a href="contas_fixas.php"><span class="icon"></span> Contas Fixas</a>
    <a href="importar_iugu.php"><span class="icon">📁</span> Importar Faturas Iugu</a>
    <a href="logout.php"><span class="icon"></span> Sair</a>
</nav>



    <!-- Resumão -->
    <div class="cards">
        <div class="card">
            <h3>Entradas</h3>
            <p style="color:green;">R$ <?= number_format($totalEntradas,2,',','.') ?></p>
        </div>
        <div class="card">
            <h3>Saídas</h3>
            <p style="color:red;">R$ <?= number_format($totalSaidas,2,',','.') ?></p>
        </div>
        <div class="card">
            <h3>Saldo</h3>
            <p class="saldo">R$ <?= number_format($saldo,2,',','.') ?></p>
        </div>
        <div class="card">
            <h3>Contas Fixas</h3>
            <p><?= $fixasPagas ?> ✅ | <?= $fixasPendentes ?> ❌</p>
        </div>
        <div class="card">
    <h3>Em mãos</h3>
    <p>R$ <?= number_format($totaisMeio['Em mãos'],2,',','.') ?></p>
</div>
<div class="card">
    <h3>Itau</h3>
    <p>R$ <?= number_format($totaisMeio['Itau'],2,',','.') ?></p>
</div>
    </div>

    <!-- Movimentos -->
<!-- Movimentos -->
<h2>Movimentos do mês</h2>
<table>
<tr>
    <th>Data</th>
    <th>Descrição</th>
    <th>Movimento</th>
    <th>Meio</th>
    <th>Valor (R$)</th>
    <th>Ações</th>
</tr>

    <?php if($movimentos): foreach($movimentos as $m): ?>
<tr>
    <td><?= date('d/m/Y', strtotime($m['data_movimento'])) ?></td>
    <td><?= htmlspecialchars($m['descricao']) ?></td>
<td class="<?= $m['tipo']=='entrada' ? 'tipo-entrada' : 'tipo-saida' ?>">
    <?= ucfirst($m['tipo']) ?>
</td>


<td><?= htmlspecialchars($m['meio_pagamento'] ?? '-') ?></td>
<td><?= number_format($m['valor'],2,',','.') ?></td>
    <td>
        <a href="editar_movimento.php?id=<?= $m['id'] ?>" class="btn-editar">Editar</a>
        <a href="excluir_movimento.php?id=<?= $m['id'] ?>" class="btn-excluir" onclick="return confirm('Tem certeza que deseja excluir este movimento?');">Excluir</a>
    </td>
</tr>
    <?php endforeach; else: ?>
        <tr><td colspan="5">Nenhum movimento neste mês.</td></tr>
    <?php endif; ?>
</table>

<style>
.tipo-entrada { color: green; font-weight:bold; }
.tipo-saida { color: red; font-weight:bold; }
</style>


    <!-- Provisões -->
    <h2>Provisões Pendentes do mês</h2>
    <table>
        <tr><th>Data Prevista</th><th>Descrição</th><th>Valor (R$)</th><th>Ação</th></tr>
<?php 
$totalProvisoes = 0; 
if($provisoes): 
    foreach($provisoes as $p): 
        $totalProvisoes += $p['valor'];
?>
    <tr>
        <td><?= date('d/m/Y', strtotime($p['data_prevista'])) ?></td>
        <td><?= htmlspecialchars($p['descricao']) ?></td>
        <td><?= number_format($p['valor'],2,',','.') ?></td>
        <td><a href="baixar_provisao.php?id=<?= $p['id'] ?>" class="btn-pagar">Pagar</a></td>
    </tr>
<?php endforeach; ?>

    <!-- Linha do TOTAL -->
    <tr>
        <th colspan="2" style="text-align:right;">TOTAL:</th>
        <th><?= number_format($totalProvisoes,2,',','.') ?></th>
        <th></th>
    </tr>

<?php else: ?>
    <tr><td colspan="4">Nenhuma provisão pendente neste mês.</td></tr>
<?php endif; ?>
</table>

<!-- Contas Fixas -->
<h2>Contas Fixas - <?= str_pad($mes,2,'0',STR_PAD_LEFT) ?>/<?= $ano ?></h2>
<table>
    <tr>
        <th>Descrição</th>
        <th>Valor</th>
        <th>Vencimento</th>
        <th>Status</th>
        <th>Ação</th>
    </tr>

<?php 
$totalFixasPendentes = 0;
$totalFixasVencidas = 0;
?>

<?php if($contasFixas): foreach($contasFixas as $c): ?>
    <?php 
    $pago = in_array($c['id'], $pagamentosMes); 
    $vencida = !$pago && ($c['dia_vencimento'] < date('d') && $mes == date('m') && $ano == date('Y'));

    // Definir classe e texto de status
    $statusClasse = $pago ? 'status-pago' : ($vencida ? 'status-vencida' : 'status-pendente');
    $statusTexto  = $pago ? '✔' : ($vencida ? 'Vencida' : 'Pendente');

    // Somar valores
    if(!$pago && !$vencida){
        $totalFixasPendentes += $c['valor'];
    }
    if($vencida){
        $totalFixasVencidas += $c['valor'];
    }
    ?>
    <tr class="<?= $vencida ? 'conta-vencida' : '' ?>">
        <td><?= htmlspecialchars($c['descricao']) ?></td>
        <td><?= number_format($c['valor'],2,',','.') ?></td>
        <td><?= str_pad($c['dia_vencimento'],2,'0',STR_PAD_LEFT) ?>/<?= str_pad($mes,2,'0',STR_PAD_LEFT) ?></td>
        <td class="<?= $statusClasse ?>"><?= $statusTexto ?></td>
        <td>
            <?php if(!$pago): ?>
                <a href="registrar_pagamento.php?id=<?= $c['id'] ?>&mes=<?= $mes ?>&ano=<?= $ano ?>" class="btn-pagar">Pagar</a>
            <?php else: ?>
                <span class="status-pago">✔</span>
            <?php endif; ?>
        </td>
    </tr>
<?php endforeach; ?>

    <!-- Totais -->
    <tr>
        <td colspan="5" style="text-align:right; font-weight:bold;">
            Total Pendente: <span style="color:blue;">R$ <?= number_format($totalFixasPendentes,2,',','.') ?></span> | 
            Total Vencido: <span style="color:red;">R$ <?= number_format($totalFixasVencidas,2,',','.') ?></span>
        </td>
    </tr>

<?php else: ?>
    <tr><td colspan="5">Nenhuma conta fixa cadastrada.</td></tr>
<?php endif; ?>
</table>


</div>
</body>
</html>
