<?php
session_start();
require 'db.php';
if(!isset($_SESSION['usuario_id'])) header("Location: index.php");

$usuario_id = $_SESSION['usuario_id'];
$msg = '';
$resumo = [];

if(isset($_POST['enviar'])){
    if(isset($_FILES['arquivo']) && $_FILES['arquivo']['error'] == 0){
        $arquivo = $_FILES['arquivo']['tmp_name'];
        $conteudo = file_get_contents($arquivo);

        // Detectar delimitador
        $delimitador = (substr_count($conteudo, "\t") > substr_count($conteudo, ",")) ? "\t" : ",";

        if(($handle = fopen($arquivo, "r")) !== FALSE){
            $linha = 0;
            $importadas = 0;
            $ignoradas = 0;

            while(($data = fgetcsv($handle, 1000, $delimitador)) !== FALSE){
                $linha++;
                if($linha == 1) continue; // pular cabeçalho

                // Ajuste as colunas de acordo com seu TXT
                $id_fatura = $data[0];         // ID da fatura
                $descricao = $data[2];         // Descrição
                $valor = floatval(str_replace(',', '.', $data[3])); 
                $data_pagamento = $data[5];   
                $status = strtolower($data[6]); 

                if($status == 'pago'){
                    // Verificar duplicidade pelo ID da fatura
                    $stmtCheck = $pdo->prepare("SELECT COUNT(*) FROM movimentos WHERE descricao LIKE ? AND valor=? AND data_movimento=?");
                    $stmtCheck->execute(['%'.$id_fatura.'%', $valor, $data_pagamento]);
                    $count = $stmtCheck->fetchColumn();

                    if($count == 0){
                        // Inserir no caixa
                        $stmt = $pdo->prepare("INSERT INTO movimentos (usuario_id, tipo, descricao, valor, data_movimento) VALUES (?,?,?,?,?)");
                        $stmt->execute([$usuario_id, 'entrada', "Fatura Iugu #$id_fatura - $descricao", $valor, $data_pagamento]);
                        $importadas++;
                    } else {
                        $ignoradas++;
                    }
                }
            }
            fclose($handle);
            $msg = "Importação concluída!";
            $resumo = [
                'importadas' => $importadas,
                'ignoradas' => $ignoradas,
            ];
        }
    } else {
        $msg = "Erro ao enviar o arquivo!";
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<title>Importar Faturas Iugu</title>
<link rel="stylesheet" href="css/style.css">
<style>
.container { max-width:600px; margin:30px auto; background:#fff; padding:20px; border-radius:8px; box-shadow:0 0 10px rgba(0,0,0,0.1);}
h1 { text-align:center; margin-bottom:20px; }
input[type=file] { padding:10px; width:100%; }
button { margin-top:15px; padding:10px 15px; background:#007bff; color:#fff; border:none; border-radius:5px; cursor:pointer; font-weight:bold; }
button:hover { background:#0056b3; }
.msg { margin-top:15px; font-weight:bold; color:green; text-align:center; }
.resumo { margin-top:15px; background:#f8f9fa; padding:10px; border-radius:5px; border:1px solid #ddd; }
</style>
</head>
<body>

<div class="container">
<h1>Importar Faturas Iugu (TXT)</h1>

        <!-- Botão Voltar -->
    <a href="dashboard.php" style="display:inline-block; margin-bottom:15px; padding:8px 12px; background:#007bff; color:#fff; text-decoration:none; border-radius:5px;">⬅ Voltar ao Dashboard</a>
    
<form method="POST" enctype="multipart/form-data">
    <input type="file" name="arquivo" accept=".txt" required>
    <button type="submit" name="enviar">Importar</button>
</form>

<?php if($msg): ?>
    <p class="msg"><?= $msg ?></p>
<?php endif; ?>

<?php if($resumo): ?>
    <div class="resumo">
        <p><strong>Faturas importadas:</strong> <?= $resumo['importadas'] ?></p>
        <p><strong>Faturas ignoradas (duplicadas):</strong> <?= $resumo['ignoradas'] ?></p>
    </div>
<?php endif; ?>
</div>
</body>
</html>
