<?php
session_start();
require 'db.php';
if(!isset($_SESSION['usuario_id'])) header("Location: index.php");

$usuario_id = $_SESSION['usuario_id'];
$msg = "";

// Salvar nova provisão
if(isset($_POST['salvar'])){
    $descricao = trim($_POST['descricao']);
    $valor = floatval($_POST['valor']);
    $data_prevista = $_POST['data_prevista'];

    if($descricao && $valor > 0 && $data_prevista){
        $stmt = $pdo->prepare("INSERT INTO provisoes (usuario_id, descricao, valor, data_prevista, status) VALUES (?,?,?,?, 'pendente')");
        $stmt->execute([$usuario_id, $descricao, $valor, $data_prevista]);
        $msg = "✅ Provisão cadastrada com sucesso!";
    } else {
        $msg = "⚠ Preencha todos os campos corretamente.";
    }
}

// Excluir provisão
if(isset($_GET['excluir'])){
    $id = (int)$_GET['excluir'];
    $stmt = $pdo->prepare("DELETE FROM provisoes WHERE id=? AND usuario_id=?");
    $stmt->execute([$id, $usuario_id]);
    $msg = "❌ Provisão excluída!";
}

// Buscar provisões do usuário
$stmt = $pdo->prepare("SELECT * FROM provisoes WHERE usuario_id=? ORDER BY data_prevista ASC");
$stmt->execute([$usuario_id]);
$provisoes = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<title>Provisões - Livro Caixa</title>
<link rel="stylesheet" href="css/style.css">
<style>
.container { max-width:800px; margin:30px auto; background:#fff; padding:20px; border-radius:8px; box-shadow:0 0 10px rgba(0,0,0,0.1);}
h1 { margin-bottom:20px; }
form input, form select { width:80%; padding:8px; margin-top:5px; border:1px solid #ccc; border-radius:5px; }
table { width:100%; border-collapse:collapse; margin-top:20px; }
th, td { border:1px solid #ccc; padding:8px; text-align:left; }
th { background:#eee; }
.msg { margin:10px 0; font-weight:bold; color:green; }
a.btn { padding:5px 10px; border-radius:5px; text-decoration:none; color:#fff; }
.btn-edit { background:#28a745; }
.btn-delete { background:#dc3545; }
.btn-edit:hover { background:#218838; }
.btn-delete:hover { background:#c82333; }
</style>
</head>
<body>
<div class="container">
    <h1>📌 Provisões</h1>
        <!-- Botão Voltar -->
    <a href="dashboard.php" style="display:inline-block; margin-bottom:15px; padding:8px 12px; background:#007bff; color:#fff; text-decoration:none; border-radius:5px;">⬅ Voltar ao Dashboard</a>


    <?php if($msg): ?>
        <p class="msg"><?= $msg ?></p>
    <?php endif; ?>

    <!-- Formulário -->
    <h2>Nova Provisão</h2>
    <form method="POST">
        <input type="text" name="descricao" placeholder="Descrição" required><br>
        <input type="number" step="0.01" name="valor" placeholder="Valor (R$)" required><br>
        <input type="date" name="data_prevista" required><br>
        <button type="submit" name="salvar">Salvar</button>
    </form>

    <!-- Listagem -->
    <h2>Provisões Cadastradas</h2>
    <table>
        <tr>
            <th>Data Prevista</th>
            <th>Descrição</th>
            <th>Valor (R$)</th>
            <th>Status</th>
            <th>Ações</th>
        </tr>
        <?php if($provisoes): foreach($provisoes as $p): ?>
        <tr>
            <td><?= date('d/m/Y', strtotime($p['data_prevista'])) ?></td>
            <td><?= htmlspecialchars($p['descricao']) ?></td>
            <td><?= number_format($p['valor'],2,',','.') ?></td>
            <td><?= ucfirst($p['status']) ?></td>
            <td>
                <a href="editar_provisao.php?id=<?= $p['id'] ?>" class="btn btn-edit">Editar</a>
                <a href="provisoes.php?excluir=<?= $p['id'] ?>" class="btn btn-delete" onclick="return confirm('Excluir provisão?')">Excluir</a>
            </td>
        </tr>
        <?php endforeach; else: ?>
        <tr><td colspan="5">Nenhuma provisão cadastrada.</td></tr>
        <?php endif; ?>
    </table>
</div>
</body>
</html>

